<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Balance extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('balance');
        $this->table = 'balance_history';
        $this->controller = 'balance';
        $this->load->helper('az_crud');
        $this->load->helper('az_app');
        $this->load->helper('az_security');
    }

	public function index(){
		$this->load->library('AZApp');
		$azapp = $this->azapp;
		$crud = $azapp->add_crud();
		$this->load->helper('az_core');

		$crud->set_column(array('#', azlang('Outlet'), azlang('Date'), azlang('Balance Code'), azlang('Customer Name'), azlang('Product'), azlang('Balance Type'), azlang('Description'), azlang('Total'), azlang('Total Balance'), azlang("Action")));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);
		$crud->set_width('10px,,,,,,,,,100px');

		$btn = "<button class='btn btn-default' type='button' id='btn_print_balance'><i class='fa fa-print'></i> ".azlang('Print')."</button>";
		$crud->set_top_filter_btn($btn);

		$v_modal = $this->load->view('balance/v_balance', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title(azlang("Balance"));
		$crud->add_btn_right_modal('save-print-balance', azlang('Save & Print'));
		$v_modal = $crud->generate_modal();

		$date = $azapp->add_datetime();
		$date->set_id('balance_date_1');
		$date->set_name('balance_date_1');
		$date->set_format('DD-MM-YYYY');
		$date->set_value('01-'.Date('m-Y'));
		$date->add_class("con-element-top-filter");
		$date = $date->render();
		$data_filter['datetime1'] = $date;

		$date = $azapp->add_datetime();
		$date->set_id('balance_date_2');
		$date->set_name('balance_date_2');
		$date->set_format('DD-MM-YYYY');
		$date->set_value(Date('t').'-'.Date('m-Y'));
		$date->add_class("con-element-top-filter");
		$date = $date->render();
		$data_filter['datetime2'] = $date;

		$v_filter = $this->load->view('balance/v_top_balance', $data_filter, true);
		$crud->set_top_filter($v_filter);

		$v_edit = $this->load->view('balance/v_modal_edit', '', true);
		$modal = $azapp->add_modal();
		$modal->set_id('edit');
		$modal->set_modal($v_edit);
		$modal->set_action_modal(array('save-edit' => azlang('Save')));
		$modal->set_modal_title('Edit');
		$azapp->add_content($modal->render());
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$js = az_add_js('balance/vjs_balance');
		$azapp->add_js($js);

		$data_header['title'] = azlang('Balance');
		$data_header['breadcrumb'] = array('balance');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();
		$crud->set_select('idbalance_history, outlet_name, balance_date, balance_code, customer_name, concat(product_code, " - ", product_name) as product, balance_name, balance_description, total, total_balance, is_void');
		$crud->set_select_table('idbalance_history, outlet_name, balance_date, balance_code, customer_name, product, balance_name, balance_description, total, total_balance');
		$crud->add_join('balance');
		$crud->add_join_manual('product', 'balance.idproduct = product.idproduct');
		$crud->add_join_manual('customer', 'balance.idcustomer = customer.idcustomer', 'left');
		$crud->add_join_manual('outlet', 'customer.idoutlet = outlet.idoutlet', 'left');
		$crud->set_filter('customer_name');
		$crud->set_sorting('outlet_name, balance_date, balance_code, customer_name, product, balance_name, balance_description, total, total_balance');
		$crud->set_id($this->controller);
		$crud->add_where("balance_history.status > 0");
		$crud->set_select_decimal('7,8');
		$crud->set_select_align(',,,,,,,right,right');
		$crud->set_table($this->table);
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$crud->add_where('customer.idoutlet = '.$sess_idoutlet);
		}
		$crud->set_edit(false);
		$crud->set_delete(false);
		$sess_idcustomer = $this->session->userdata('idcustomer');
		if (strlen($sess_idcustomer) > 0) {
			$crud->add_where('balance.idcustomer = "'.$sess_idcustomer.'"');
		}
		$crud->set_custom_style('custom_style');
		$crud->set_order_by('balance_date desc');
		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		if ($key == 'action') {
			$balance_name = azarr($data, 'balance_name');
			$id = azarr($data, 'idbalance_history');
			$btn = '';
			// $btn = "<button class='btn btn-default btn-xs btn-edit' data-id='".$id."'><i class='fa fa-pencil'></i> Edit</button>";
			$is_void = azarr($data, 'is_void');
			if (!$is_void) {
				// $btn .= '<button type="button" class="btn btn-void btn-warning btn-xs" data-id="'.$id.'"><i class="fa fa-remove"></i> Void</button>';
			}
			else {
				$btn .= '<label class="label label-default">Void</label>';
			}
			if ($balance_name == 'TOPUP') {
				$idbalance_history = azarr($data, 'idbalance_history');
				$btn .= "<a href='".app_url()."balance/print_nota/?id=".az_encode_url($idbalance_history)."' target='_blank'><button class='btn btn-xs btn-print-topup btn-primary'><i class='fa fa-print'></i> ".azlang('Print Nota')."</button></a>";
			}
			return $btn;

		}
		return $value;
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data['sMessage'] = '';
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) == 0) {
			$this->form_validation->set_rules('idoutlet', azlang('Outlet'), 'required|trim');
			$idoutlet = azarr($data_post, 'idoutlet');
		}
		$this->form_validation->set_rules('balance_type', azlang('Balance Type'), 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idcustomer', azlang('Customer'), 'required|trim|max_length[200]');
		$type = $this->input->post('balance_type');
		if ($type == 'TOPUP') {
			$this->form_validation->set_rules('idproduct', azlang('Product'), 'required|trim|max_length[200]');
		}
		else {
			$this->form_validation->set_rules('idcustomer_package', azlang('Customer Package'), 'required|trim|max_length[200]');
			$this->form_validation->set_rules('total', azlang('Total'), 'required|trim|max_length[200]');	
		}

		$err_code = 0;
		$err_message = '';
		$the_id = "";

		if($this->form_validation->run() == TRUE){
            $idcustomer = $this->input->post('idcustomer');
            $idproduct = $this->input->post('idproduct');
            $balance_description = $this->input->post('balance_description');
            $idcustomer_package = $this->input->post('idcustomer_package');
            $total = $this->input->post('total');

            if ($type == 'TOPUP') {
	            $this->db->where('idproduct', $idproduct);
	            $product = $this->db->get('product');

	            // $date_start = Date('Y-m-d');
	            // $date_end = Date('Y-m-d', strtotime($date_start. ' + '.$validity_period.' days'));
	            $balance = $product->row()->quota;

	            $this->db->where('idcustomer', $idcustomer);
	            $this->db->where("idproduct", $idproduct);
	            $check = $this->db->get('balance');
	            $recent_balance = 0;
	            $idbalance = '';
	            if ($check->num_rows() > 0) {
	            	$recent_balance = $check->row()->balance;
	            	$idbalance = $check->row()->idbalance;
	            }

	            $new_balance = $recent_balance + $balance;

	            $arr_balance = array(
	            	'idcustomer' => $idcustomer,
	            	'idproduct' => $idproduct,
	            	'balance' => $new_balance
	            );
	            $save_balance = az_crud_save($idbalance, 'balance', $arr_balance);

	            $idbalance = azarr($save_balance, 'insert_id');

	            $total = $balance;
	            $total_balance = $balance;

	            if ($check->num_rows() == 0) {
		            $arr_balance_history = array(
		            	'idbalance' => $idbalance,
		            	'balance_date' => Date('Y-m-d H:i:s'),
		            	'balance_type' => 'TOPUP',
		            	'balance_name' => 'TOPUP',
		            	'total' => az_crud_number($total),
		            	'balance_description' => $balance_description,
		            	'total_balance' => $total_balance
		            );

		            $save_balance_history = az_crud_save('', 'balance_history', $arr_balance_history);
		            $idbalance_history = azarr($save_balance_history, 'insert_id');

		            $arr_code = array(
		            	'balance_code' => 'SAL-'.sprintf('%03d', $idbalance_history)
		            );
		            az_crud_save($idbalance_history, 'balance_history', $arr_code);
	            }
	            else {
	            	$post_balance = array(
		            	'idbalance' => $idbalance,
		            	'balance_name' => 'TOPUP',
		            	'total' => az_crud_number($total),
		            	'type' => 'IN',
		            	'balance_description' => $balance_description
		            );
		            $idbalance_history = az_update_balance($post_balance);
	            }

	            $the_id = az_encode_url($idbalance_history);
            }
            else {
	            $post_balance = array(
	            	'idbalance' => $idcustomer_package,
	            	'total' => az_crud_number($total),
	            	'type' => $type,
	            	'balance_description' => $balance_description
	            );
	            az_update_balance($post_balance);
            }
		}
		else {
			$err_code++;
			$err_message = validation_errors();
		}

		$data["sMessage"] = $err_message;
		$data["id"] = $the_id;
		echo json_encode($data);
	}

	function get_price() {
		$id = $this->input->post("idproduct");
		$total = 0;
		$this->db->where('idproduct', $id);
		$data = $this->db->get('product');

		if ($data->num_rows() > 0) {
			$total = $data->row()->quota;
			if (strlen($total) == 0) {
				$total = 0;
			}
		}
		$ret = array(
			'total' => $total
		);
		echo json_encode($ret);
	}

	function print_balance() {
	   	$idoutlet = $this->input->post('idfidoutlet');
    	$idcustomer = $this->input->post('idfidcustomer');
    	$date1 = $this->input->post('balance_date_1');
    	$date2 = $this->input->post('balance_date_2');
    	$balance_type = $this->input->post('balance_type');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		$sess_idcustomer = $this->session->userdata('idcustomer');
		if (strlen($sess_idoutlet) > 0) {
			$idoutlet = $sess_idoutlet;
		}
		if (strlen($sess_idcustomer) > 0) {
			$idcustomer = $sess_idcustomer;
		}
		if (strlen($balance_type) > 0) {
			$this->db->where('balance_type', $balance_type);
		}
		$this->db->where('balance_date >= "'.Date('Y-m-d', strtotime($date1)).' 00:00:00"');
		$this->db->where('balance_date <= "'.Date('Y-m-d', strtotime($date2)).' 23:59:59"');
		$this->db->select('idbalance_history, outlet_name, balance_date, balance_code, customer_name, concat(product_code, " - ", product_name) as product, balance_name, balance_description, total, total_balance, sell_price');
		$this->db->join('balance', 'balance_history.idbalance = balance.idbalance');
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->join('customer', 'balance.idcustomer = customer.idcustomer', 'left');
		$this->db->join('outlet', 'customer.idoutlet = outlet.idoutlet', 'left');
		$this->db->where("balance_history.status > 0");
		if (strlen($idoutlet) > 0) {
			$this->db->where('customer.idoutlet = '.$idoutlet);
		}
		if (strlen($idcustomer) > 0) {
			$this->db->where('balance.idcustomer = "'.$idcustomer.'"');
		}
		
		$this->db->order_by('balance_date desc');
		$data['data'] = $this->db->get('balance_history');
		$data['date1'] = $date1;
		$data['date2'] = $date2;
		$show_total = false;
		if ($balance_type == 'TOPUP') {
			$show_total = true;
		}
		$data['show_total'] = $show_total;

		$this->load->view('balance/v_print_balance', $data);

	}

	function print_nota() {
		$id = $this->input->get('id');
		$id = az_decode_url($id);

		$this->db->where('idbalance_history', $id);
		$this->db->select('outlet_name, outlet.address, outlet.phone, balance_code, sell_price as product_price, balance_date, balance_description, total, total_balance, customer_name, product_name');
		$this->db->join('balance', 'balance_history.idbalance = balance.idbalance');
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->join('customer', 'balance.idcustomer = customer.idcustomer');
		$this->db->join('outlet', 'customer.idoutlet = outlet.idoutlet');
		$data = $this->db->get('balance_history');

		if ($data->num_rows() == 0) {
			redirect(app_url());
		}

		$rdata['data'] = $data->row();
		$this->load->view('balance/v_balance_nota', $rdata);
	}

	function save_edit() {
		$id = $this->input->post("edit_idbalance_history");
		$description = $this->input->post("edit_description");

		$arr = array(
			'balance_description' => $description
		);

		$this->db->where('idbalance_history', $id);
		$this->db->update('balance_history', $arr);

		echo json_encode(array('ok' => 'ok'));
	}

	function get_edit() {
		$id = $this->input->post('id');
		$this->db->where('idbalance_history', $id);
		$this->db->select("idbalance_history, balance_description");
		$data = $this->db->get('balance_history')->result_array();
		$rdata = azarr($data, 0);

		echo json_encode($rdata);
	}

	function void() {
		$id = $this->input->post('id');
		$arr_void = array(
			'is_void' => 1
		);

		$this->db->where('idbalance_history', $id);
		$this->db->update('balance_history', $arr_void);

		$this->db->where('idbalance_history', $id);
		$data = $this->db->get('balance_history');

		$db_type = $data->row()->balance_type;
		if ($db_type == 'IN') {
			$type = 'OUT';
		}
		else if ($db_type == 'OUT') {
			$type = 'IN';
		}
		else {
			$type = 'OUT';
		}

		$post_balance = array(
        	'idbalance' => $data->row()->idbalance,
        	'total' => $data->row()->total,
        	'type' => $type,
        	'balance_description' => 'VOID '.$data->row()->balance_code
        );
        $the_id = az_update_balance($post_balance);

        $this->db->where('idbalance_history', $the_id);
        $this->db->update('balance_history', $arr_void);

        echo json_encode(array('ok' => 'ok'));
	}
}