<?php
    $ci =& get_instance();
    $ci->load->helper('az_config');
    $ci->load->helper('az_core');
    $store_name = az_get_config('app_name');
    $store_description = az_get_config('app_description');
?>
<html moznomarginboxes mozdisallowselectionprint>
    <head>
        <title>
            <?php echo $data['outlet_name'].' - '.azlang('Print Nota');?>
        </title>
        <style type="text/css">
            html {
                font-family: "Verdana";
            }
            .content {
                width: 58mm;
                font-size: 12px;
                padding: 5px;
            }
            
            .content .title {
                text-align: center;
            }
            .content .head-desc {
                margin-top: 10px;
                display: table;
                width: 100%;
            }
            .content .head-desc > div {
                display: table-cell;
            }
            .content .head-desc .user {
                text-align: right;
            }
            .content .nota {
                text-align: center;
                margin-top: 5px;
                margin-bottom: 5px;
            }
            .content .separate {
                margin-top: 10px;
                margin-bottom: 15px;
                border-top: 1px dashed #000;
            }
            .content .transaction-table {
                width: 100%;
                font-size: 12px;
            }
            .content .transaction-table .name {
                width: 185px;
            }
            .content .transaction-table .qty {
                text-align: center;
            }
            .content .transaction-table .sell-price, .content .transaction-table .final-price {
                text-align: right;
                width: 65px;
            }
            .content .transaction-table tr td {
                vertical-align: top;
            }
            .content .transaction-table .price-tr td {
                padding-top: 7px;
                padding-bottom: 7px;
            }
            .content .transaction-table .discount-tr td {
                padding-top: 7px;
                padding-bottom: 7px;
            }
            .content .transaction-table .separate-line {
                height: 1px;
                border-top: 1px dashed #000;
            }
            .content .thanks {
                margin-top: 15px;
                text-align: center;
            }
            .content .azost {
                margin-top:5px;
                text-align: center;
                font-size:10px;
            }
        </style>
    </head>
    <body onload="window.print();">
        <div class="content">
            <div style="text-align:center;">
                <img style="display:inline-block;" height="58px" src="<?php echo base_url().AZAPP;?>assets/images/logo.png">
            </div>
            <div class="title">
                <?php echo $data['outlet_address'];;?><br>
                <?php echo $data['outlet_phone'];;?><br>
            </div>

            <div class="head-desc">
                <div class="date">
                    <?php
                        echo Date("d-m-Y H:i", strtotime($data['transaction_date']));
                    ?>
                </div>
                <div class="user">
                    <?php
                        echo $data['customer_name'];
                    ?>
                </div>
            </div>
            
            <div class="nota">
                <?php echo $data['transaction_code'];?>
            </div>

            <div class="separate"></div>

            <div class="transaction">
                <table class="transaction-table" cellspacing="0" cellpadding="0">
                    <tr>
                        <td><?php echo $data['product_name'];?></td>
                        <td align="right"><?php echo az_thousand_separator_decimal($data['total']);?></td>
                    </tr>

                    <tr class="price-tr">
                        <td colspan="2">
                            <div class="separate-line"></div>
                        </td>
                    </tr>
                </table>
            </div>
            <div style="margin-top:5px;margin-bottom:5px;">
                <div>Status Transaksi: <?php echo azlang($data['transaction_status']);?></div>
                <!-- <div>Sisa Kuota: <?php //echo azlang($balance);?> KG</div> -->
                <?php 
                    foreach ($balance->result() as $key => $value) {
                        echo '<div>'.$value->product.': '.$value->balance.'</div>';
                    }
                ?>
            </div>
            <div style="margin-top:10px;margin-bottom:10px;">
                <?php echo $data['transaction_description'];?>
            </div>
            <div>
                <?php echo az_get_config('app_footer_nota');?>
            </div>
        </div>
    </body>
</html>