-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.6.21 - MySQL Community Server (GPL)
-- Server OS:                    Win32
-- HeidiSQL Version:             9.3.0.4984
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table az_laundry.config
CREATE TABLE IF NOT EXISTS `config` (
  `idconfig` int(11) NOT NULL AUTO_INCREMENT,
  `key` text,
  `value` text,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idconfig`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.config: ~5 rows (approximately)
/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT IGNORE INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(1, 'app_name', 'AZLaundry', '2016-11-04 02:02:19', NULL, '2016-11-04 02:02:19', NULL, 1),
	(2, 'app_description', 'Laundry Management System', '2016-11-04 02:02:31', NULL, '2016-11-04 02:02:31', NULL, 1),
	(3, 'app_preface', '<p>Selamat bekerja, go go go</p>\r\n', '2016-11-13 20:24:26', NULL, '2016-11-13 20:24:27', NULL, 1),
	(4, 'app_login_title', 'AZLaundry', '2016-11-20 18:42:44', NULL, '2016-11-20 18:42:45', NULL, 1),
	(5, 'app_footer_nota', '~~~ Terima Kasihxx ~~~\r\n', NULL, NULL, NULL, NULL, 1);
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


-- Dumping structure for table az_laundry.customer
CREATE TABLE IF NOT EXISTS `customer` (
  `idcustomer` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `customer_code` varchar(200) DEFAULT NULL,
  `customer_name` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `phone` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idcustomer`),
  KEY `FK_customer_outlet` (`idoutlet`),
  CONSTRAINT `FK_customer_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.customer: ~6 rows (approximately)
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;


-- Dumping structure for table az_laundry.outlay
CREATE TABLE IF NOT EXISTS `outlay` (
  `idoutlay` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idoutlay_type` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `description` text,
  `datetime` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlay`),
  KEY `FK__outlay_type` (`idoutlay_type`),
  KEY `FK_outlay_outlet` (`idoutlet`),
  CONSTRAINT `FK__outlay_type` FOREIGN KEY (`idoutlay_type`) REFERENCES `outlay_type` (`idoutlay_type`),
  CONSTRAINT `FK_outlay_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.outlay: ~1 rows (approximately)
/*!40000 ALTER TABLE `outlay` DISABLE KEYS */;
/*!40000 ALTER TABLE `outlay` ENABLE KEYS */;


-- Dumping structure for table az_laundry.outlay_type
CREATE TABLE IF NOT EXISTS `outlay_type` (
  `idoutlay_type` int(11) NOT NULL AUTO_INCREMENT,
  `outlay_type_name` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlay_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.outlay_type: ~3 rows (approximately)
/*!40000 ALTER TABLE `outlay_type` DISABLE KEYS */;
INSERT IGNORE INTO `outlay_type` (`idoutlay_type`, `outlay_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(10, 'Foto Copy', '2017-07-08 00:55:48', 'administrator', '2017-07-08 00:55:48', 'administrator', 1),
	(11, 'Bensin', '2017-07-08 00:55:53', 'administrator', '2017-07-08 00:55:53', 'administrator', 1),
	(12, 'Air Minum', '2017-07-08 00:56:01', 'administrator', '2017-07-08 00:56:01', 'administrator', 1);
/*!40000 ALTER TABLE `outlay_type` ENABLE KEYS */;


-- Dumping structure for table az_laundry.outlet
CREATE TABLE IF NOT EXISTS `outlet` (
  `idoutlet` int(11) NOT NULL AUTO_INCREMENT,
  `outlet_code` varchar(3) DEFAULT NULL,
  `outlet_name` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `phone` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.outlet: ~2 rows (approximately)
/*!40000 ALTER TABLE `outlet` DISABLE KEYS */;
INSERT IGNORE INTO `outlet` (`idoutlet`, `outlet_code`, `outlet_name`, `address`, `phone`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(14, 'OT1', 'Laundry Pertama', 'Jl. Indonesia Raya', '08123123123', '2017-07-04 00:36:05', 'superadmin', '2017-07-04 00:36:05', 'superadmin', 1),
	(15, 'OT2', 'Wangi Laundry', 'Surabaya', '08123123123', '2017-07-08 00:13:40', 'administrator', '2017-07-08 00:13:40', 'administrator', 1);
/*!40000 ALTER TABLE `outlet` ENABLE KEYS */;


-- Dumping structure for table az_laundry.product
CREATE TABLE IF NOT EXISTS `product` (
  `idproduct` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `product_type` varchar(50) DEFAULT NULL COMMENT 'UNIT/KILOGRAM',
  `product_code` varchar(200) DEFAULT NULL,
  `product_name` varchar(200) DEFAULT NULL,
  `description` text,
  `sell_price` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idproduct`),
  KEY `FK_product_outlet` (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.product: ~0 rows (approximately)
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
/*!40000 ALTER TABLE `product` ENABLE KEYS */;


-- Dumping structure for table az_laundry.role
CREATE TABLE IF NOT EXISTS `role` (
  `idrole` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.role: ~2 rows (approximately)
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT IGNORE INTO `role` (`idrole`, `parent`, `name`, `title`, `description`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(9, 0, 'administrator', 'Administrator', 'Administrator', '2017-03-17 21:42:21', 'superadmin', '2017-03-17 21:42:21', 'superadmin', 1),
	(10, 9, 'cashier', 'Cashier', 'Cashier', '2017-03-17 21:42:39', 'superadmin', '2017-03-17 21:42:39', 'superadmin', 1);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;


-- Dumping structure for table az_laundry.transaction
CREATE TABLE IF NOT EXISTS `transaction` (
  `idtransaction` int(11) NOT NULL AUTO_INCREMENT,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `idproduct` int(11) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `price` double DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `add_cost` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `total` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction`),
  KEY `FK_transaction_product` (`idproduct`),
  KEY `FK_transaction_transaction_group` (`idtransaction_group`),
  CONSTRAINT `FK_transaction_product` FOREIGN KEY (`idproduct`) REFERENCES `product` (`idproduct`),
  CONSTRAINT `FK_transaction_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.transaction: ~0 rows (approximately)
/*!40000 ALTER TABLE `transaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction` ENABLE KEYS */;


-- Dumping structure for table az_laundry.transaction_detail
CREATE TABLE IF NOT EXISTS `transaction_detail` (
  `idtransaction_detail` int(11) NOT NULL AUTO_INCREMENT,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `detail_description` varchar(300) DEFAULT NULL,
  `detail_qty` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction_detail`),
  KEY `FK_transaction_detail_transaction_group` (`idtransaction_group`),
  CONSTRAINT `FK_transaction_detail_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.transaction_detail: ~0 rows (approximately)
/*!40000 ALTER TABLE `transaction_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_detail` ENABLE KEYS */;


-- Dumping structure for table az_laundry.transaction_group
CREATE TABLE IF NOT EXISTS `transaction_group` (
  `idtransaction_group` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idcustomer` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `code` varchar(200) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `duedate` datetime DEFAULT NULL,
  `pay_date` datetime DEFAULT NULL,
  `grand_total` double DEFAULT NULL,
  `grand_discount` double DEFAULT NULL,
  `grand_discount_percent` double DEFAULT NULL,
  `grand_add_cost` double DEFAULT NULL,
  `grand_tax` double DEFAULT NULL,
  `grand_tax_percent` double DEFAULT NULL,
  `grand_total_final` double DEFAULT NULL,
  `pay` varchar(50) DEFAULT NULL COMMENT 'PAID/NOT PAID YET',
  `transaction_group_status` varchar(50) DEFAULT NULL COMMENT 'NEW/PROGRESS/FINISH/ACCEPTED',
  `note` text,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction_group`),
  KEY `FK_transaction_group_outlet` (`idoutlet`),
  KEY `FK_transaction_group_customer` (`idcustomer`),
  KEY `FK_transaction_group_user` (`iduser`),
  CONSTRAINT `FK_transaction_group_customer` FOREIGN KEY (`idcustomer`) REFERENCES `customer` (`idcustomer`),
  CONSTRAINT `FK_transaction_group_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
  CONSTRAINT `FK_transaction_group_user` FOREIGN KEY (`iduser`) REFERENCES `user` (`iduser`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.transaction_group: ~0 rows (approximately)
/*!40000 ALTER TABLE `transaction_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `transaction_group` ENABLE KEYS */;


-- Dumping structure for table az_laundry.user
CREATE TABLE IF NOT EXISTS `user` (
  `iduser` int(11) NOT NULL AUTO_INCREMENT,
  `idrole` int(11) DEFAULT NULL,
  `idoutlet` int(11) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iduser`),
  KEY `FK_user_role` (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.user: ~4 rows (approximately)
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT IGNORE INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(1, NULL, NULL, 'superadmin', '85bb6dec1873bb465770dde5e5264517', 'Superadmin', 'superadmin@superadmin.com', 'Indonesia', '2016-10-30 15:46:48', 'system', '2016-10-30 15:46:48', 'system', 1),
	(2, 9, NULL, 'administrator', '5f4dcc3b5aa765d61d8327deb882cf99', 'administrator', 'admin@admin.com', 'Indonesia', '2017-04-24 23:17:59', 'superadmin', '2017-06-18 16:28:34', 'administrator', 1),
	(10, 10, 14, 'cashier', '5f4dcc3b5aa765d61d8327deb882cf99', 'The Cashier', 'cashier@gmail.com', 'Lamongan', '2017-07-07 22:42:58', 'superadmin', '2017-07-08 01:08:33', 'administrator', 1),
	(11, 10, 15, 'cashierwangi', '5f4dcc3b5aa765d61d8327deb882cf99', 'Wangi Cashier', 'wangi@gmail.com', 'Surabaya', '2017-07-08 01:19:28', 'administrator', '2017-07-08 01:19:28', 'administrator', 1);
/*!40000 ALTER TABLE `user` ENABLE KEYS */;


-- Dumping structure for table az_laundry.user_role
CREATE TABLE IF NOT EXISTS `user_role` (
  `iduser_role` int(11) NOT NULL AUTO_INCREMENT,
  `idrole` int(11) DEFAULT NULL,
  `menu_name` varchar(200) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iduser_role`),
  KEY `FK_user_role_role` (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

-- Dumping data for table az_laundry.user_role: ~38 rows (approximately)
/*!40000 ALTER TABLE `user_role` DISABLE KEYS */;
INSERT IGNORE INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES
	(1, 9, 'dashboard', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:39', 'superadmin', 1),
	(2, 9, 'master', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:39', 'superadmin', 1),
	(3, 9, 'outlet', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(4, 9, 'customer', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(5, 9, 'outlay_type', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(6, 9, 'product', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(7, 9, 'transaction', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(8, 9, 'outlay', 1, '2017-07-07 23:17:19', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(9, 9, 'report', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(10, 9, 'profit_report', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(11, 9, 'user', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(12, 9, 'user_role', 0, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(13, 9, 'user_user', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(14, 9, 'user_user_role', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(15, 9, 'setting', 1, '2017-07-07 23:17:20', 'superadmin', '2017-10-22 12:24:41', 'superadmin', 1),
	(16, 10, 'dashboard', 1, '2017-07-07 23:17:39', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(17, 10, 'master', 0, '2017-07-07 23:17:39', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(18, 10, 'outlet', 0, '2017-07-07 23:17:39', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(19, 10, 'customer', 0, '2017-07-07 23:17:39', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(20, 10, 'outlay_type', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(21, 10, 'product', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(22, 10, 'transaction', 1, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:57', 'superadmin', 1),
	(23, 10, 'outlay', 1, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(24, 10, 'report', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(25, 10, 'profit_report', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(26, 10, 'user', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(27, 10, 'user_role', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(28, 10, 'user_user', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(29, 10, 'user_user_role', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(30, 10, 'setting', 0, '2017-07-07 23:17:40', 'superadmin', '2017-10-22 12:24:58', 'superadmin', 1),
	(31, 9, 'role_add_transaction', 1, '2017-10-22 12:08:30', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(32, 9, 'role_process_transaction', 1, '2017-10-22 12:08:31', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(33, 9, 'role_edit_transaction', 1, '2017-10-22 12:08:31', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(34, 9, 'role_delete_transaction', 1, '2017-10-22 12:08:31', 'superadmin', '2017-10-22 12:24:40', 'superadmin', 1),
	(35, 10, 'role_add_transaction', 1, '2017-10-22 12:24:57', 'superadmin', NULL, NULL, 1),
	(36, 10, 'role_process_transaction', 1, '2017-10-22 12:24:57', 'superadmin', NULL, NULL, 1),
	(37, 10, 'role_edit_transaction', 0, '2017-10-22 12:24:57', 'superadmin', NULL, NULL, 1),
	(38, 10, 'role_delete_transaction', 0, '2017-10-22 12:24:57', 'superadmin', NULL, NULL, 1);
/*!40000 ALTER TABLE `user_role` ENABLE KEYS */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
