<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer_balance extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('customer_balance');
        $this->table = 'balance';
        $this->controller = 'customer_balance';
        $this->load->helper('az_crud');
    }

	public function index(){
		$this->load->library('AZApp');
		$azapp = $this->azapp;
		$crud = $azapp->add_crud();
		$this->load->helper('az_core');

		$crud->set_column(array('#', azlang('Outlet'), azlang('Customer Name'), azlang('Product Package'), azlang('Total Balance')));
		$crud->set_id($this->controller);
		$crud->set_th_class('no-sort,,,,,,,');
		$crud->set_default_url(true);
		$crud->set_btn_add(false);
		$crud->set_single_filter(false);
		$data_filter = array();

		$role_name = $this->session->userdata('role_name');
		
		$v_filter = $this->load->view('customer_balance/v_top_balance', $data_filter, true);
		$crud->set_top_filter($v_filter);

		$btn = "<button class='btn btn-info' type='button' id='btn_print'>Cetak</button>";
		$crud->set_btn_top_custom($btn);

		$js = az_add_js('customer_balance/vjs_customer_balance');
		$azapp->add_js($js);

		$crud->add_aodata('fbalance', 'fbalance');
		
		$crud = $crud->render();
		$azapp->add_content($crud);

		$data_header['title'] = azlang('Customer Balance');
		$data_header['breadcrumb'] = array('customer_balance');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();

		$fbalance = $this->input->get('fbalance');
		if (strlen($fbalance) > 0) {
			// echo $fbalance;die;
			$tbalance = '<= 0';
			if ($fbalance == 'more') {
				$tbalance = '> 0';
			}
			$crud->add_where('balance '.$tbalance);
		}

		$crud->set_select('idbalance, outlet_name, customer_name, concat(product_code," - ", product_name) as product, balance as balance_ori, concat(balance, " KG") as balance');
		$crud->set_select_table('outlet_name, customer_name, product, balance');
		$crud->add_join_manual('product', 'balance.idproduct = product.idproduct');
		$crud->add_join_manual('customer', 'balance.idcustomer = customer.idcustomer', 'left');
		$crud->add_join_manual('outlet', 'customer.idoutlet = outlet.idoutlet', 'left');
		$crud->set_filter('customer_name');
		$crud->set_sorting('outlet_name, customer_name, product_name, balance_ori');
		$crud->set_id($this->controller);
		$crud->add_where("balance.status > 0");
		$crud->set_select_number('2');
		$crud->set_select_align(',,,right');
		$crud->set_table($this->table);
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$crud->add_where('customer.idoutlet = '.$sess_idoutlet);
		}
		$sess_idcustomer = $this->session->userdata('idcustomer');
		if (strlen($sess_idcustomer) > 0) {
			$crud->add_where('balance.idcustomer = "'.$sess_idcustomer.'"');
		}
		$crud->set_order_by('product_name');
		echo $crud->get_table();
	}

	function print_data($id) {
		$this->load->helper('az_config');
		$this->db->where('balance.status', 1);
		$this->db->where('balance.idcustomer', $id);
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->join('customer', 'balance.idcustomer = customer.idcustomer');
		$this->db->select('concat(product_code," - ", product_name) as product, balance as balance_ori, concat(balance, " KG") as balance');
		$data['data'] = $this->db->get('balance');

		$this->db->where("idcustomer", $id);
		$data['cs'] = $this->db->get('customer')->row()->customer_name;

		$this->load->view('customer_balance/v_print', $data);
	}
}